# Dash Embedded

### Documentation

Dash Embedded allows you to make Dash apps that work both standalone (in their own webpage) or as components in a parent application. In your Dash app, simply add `plugins=[dash_embedded.Embeddable(origins=['*'])]` to the `dash.Dash` constructor.

> **Please Note:** `origins=['*']` opens your app to requests from any domain, so presents a security risk if your app is accessible from the public internet. You should specify the actual domains of the applications that are allowed to access this app. See the `flask_cors` package for more information.

Deploy your app as usual, and view it standalone as usual, then add a `<DashApp />` component to your parent application, point it at the url of your dash app, and provide any required extra info like an auth token. That's it! For usage examples, see the `dash-embedded-app` package.

For more info about Dash itself, view the [Dash User Guide](https://dash.plotly.com/). It's chock-full of examples, pro tips, and guiding principles.

### Packaging

Use the `sdist` and `bdist_wheel` commands:

```python
python setup.py sdist bdist_wheel --universal
```

to generate a source archive (`dash_embedded-x.y.z.tar.gz`) and a built distribution
(`dash_embedded-x.y.z-py2.py3-none-any.whl`).

### Licensing

Dash Embedded may only be used with the express written permission of Plotly, Inc.

### Contact and Support

See [https://dash.plotly.com/support](https://dash.plotly.com/support) for ways to get in touch.

---

![image](https://user-images.githubusercontent.com/1280389/30084008-9fbc68fc-925e-11e7-891c-18a9b8f6ac6b.png)
